<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class ClassRoom extends Model
{
    use HasFactory;

    protected $fillable = [
        'course_id',
        'name',
        'trainer_id',
    ];

    public function certificates()
    {
        return $this->hasMany(Certificate::class,'room_id');
    }
    public function course()
    {
        return $this->belongsTo(Course::class,'course_id');
    }

    public function trainer()
    {
        return $this->belongsTo(User::class,'trainer_id');
    }

    public function coordinator()
    {
        return $this->belongsTo(User::class,'coordinator_id');
    }

    public function students()
    {
        return $this->hasMany(StudentSubscribe::class,'room_id');
    }

    public function appendixes()
    {
        return $this->hasMany(Appendix::class,'room_id');
    }

    public function exams()
    {
        return $this->hasMany(Exam::class,'room_id');
    }
    
    #Scope
    ######################
    #######################
    public function scopeActive($query)
    {
        return $query->where('is_active', 1);
    }

}

